; with extra lcd initialisation
; Frequency Meter using LCD and ADA4899 op amps for input amplifier
; 
; 10kHz rounding up addition for use with 10kHz band radio control transmitters.
; 1000:1 prescaler units option

;  +/-50ppm adjustment for calibration with Real Time Clock to check drift over time

	list P=16F88
	#include p16f88.inc
	ERRORLEVEL -302
	ERRORLEVEL -306

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF &  _HS_OSC

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations

EEPROM1	equ	H'00'	; Mode/resolution and rounding + prescaler
EEPROM2	equ	H'01'	; backlight dimming value storage
EEPROM3	equ	H'02'	; ppm offset 
 
; RAM

ESEVN		equ	H'20'	; 10 000,000 (digit 8)
ESIX		equ	H'21'	; 1000,000s (digit 7 )
EFIVE		equ	H'22'	; 100,000s digit 6 store
EFOUR		equ	H'23'	; 10,000s digit 5 store
ETHREE	equ	H'24'	; 1000s digit 4 store (kHz)
ETWO		equ	H'25'	; 100s digit 3 store
EONE		equ	H'26'	; 10s digit 2 store
EZERO		equ	H'27'	; 1's digit 1 store (Hz)
REG_C		equ	H'28'	; frequency counter LS byte
REG_B		equ	H'29'	; frequency counter 
REG_A		equ	H'2A'	; frequency counter MS byte 
D_STO		equ	H'2B'	; data store
FLAG		equ	H'2C'	; flag to include delay for 100ms update
TIMER		equ	H'2D'	; most significant byte of timer (TMR0) value
SAMPLE	equ	H'2E'   	; period of frequency counting
STORE1		equ	H'2F'	; temporary storage
STORE2		equ	H'30'	; temporary storage
ADDRESS	equ	H'31'	; display address position
CARRY_B	equ	H'32'	; carry borrow storage
FLAG_1		equ	H'33'	; flag for start of .1Hz resolution count
DATA_S		equ	H'34'	; data storage
COUNT		equ	H'35'	; Binary conversion counter
BCD1		equ	H'36'	; overrange
BCD2		equ	H'37'	; MS decimal value
BCD3		equ	H'38'	; 
BCD4		equ	H'39'	; 
BCD5		equ	H'3A'	; LS decimal value	
BIN1		equ	H'3B'	; LS binary value
BIN2		equ	H'3C'	; 
BIN3		equ	H'3D'	; 
BIN4		equ	H'3E'	; MS binary value

MODE_VAL	equ	H'40'	; display mode/ resolution/rounding/prescaler
STORE3		equ	H'41'	; delay storage value
FLAG_S		equ	H'42'	; await signal flag
TIME_I		equ	H'43'	; initial timer
STOREX	equ	H'44'	; display count store
TEMPX		equ	H'45'	; delay register
TEMP_M	equ	H'46'	; temporary mode after conversion from MODE_VAL
RATE		equ	H'47'	; dimming rate 
DIR			equ	H'48'	; dimming direction
PPM		equ	H'49'	; ppm adjust
FIX		    	equ	H'4A'	; timebase fix value
SIGNX		equ	H'4B'	; sign (-) flag
PPM_STO	equ	H'4C'	; store PPM
START		equ	H'4D'	; start flag

CORRECTION		equ	H'4E'	; correction value for clock in ppm (0-+/-50), - slows clock, + speeds it up (in 1ppm steps)
MSECS				equ	H'4F'	; milliseconds counter (25/second)
SECONDS_RTC		equ	H'50'	; RTC seconds
UPDATE_FLG		equ	H'51'	; display update flag

SEC1				equ	H'52'	; seconds counter lsb
SEC2				equ	H'53'	; seconds counter 
SEC3				equ	H'54'	; seconds counter msb

; math routines

SIGN        	equ H'60'   	; save location for sign 
TEMPB1      	equ H'61'
TEMPB0     	equ H'62'
TEMPD       	equ H'63'	; temporary storage
AARGB2      	equ H'64'
AARGB1     	equ H'65'
AARGB0     	equ H'66'
AARG        	equ H'67'   	; most significant byte of argument A
BARGB2	equ	H'68'
BARGB1      	equ H'69'
BARGB0      	equ H'6A'
BARG        	equ H'6B'   	; most significant byte of argument B
REMB2	    	equ	H'6C'
REMB1       	equ H'6D'
REMB0       	equ H'6E'   	; most significant byte of remainder
LPCOUNT   	equ H'6F'   	; loop counter

; all banks ram
W_TMP			equ	H'70'	; storage of w before interrupt
STATUS_TMP	equ	H'71'	; status storage before interrupt
SECONDS		equ	H'72'	; seconds counter
MINUTES		equ	H'73'	; minutes RTC
HOURS			equ	H'74'	; hours RTC
BCD_0			equ	H'75'	; MS bcd value
BCD_1			equ	H'76'	; LS binary coded decimal value
BIN_0			equ	H'77'	; 8-bit binary value
TEMP			equ	H'78'	; data storage 
CNT_8			equ	H'79'	; counter in BCD routine
OUT1			equ	H'7A'	; ASCII byte
OUT2			equ	H'7B'	; ASCII byte
OUT3			equ	H'7C'	; ASCII byte
PCLATH_STO	equ	H'7D'	; PCLATH storage

; preprogram EEPROM DATA
	
	ORG     	2100
	DE		H'00'		; low resolution no prescaler
	DE		H'FF'		; max brightness for backlight
	DE		D'50'		; ppm setting zero shift

; start at memory 0

	org	0	
	goto	MAIN
	org	4	; interrupt

; start interrupt by saving w and status registers  
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	movf	PCLATH,w	; keep PCLATH
	movwf	PCLATH_STO	; store PC lath
	bsf		PCLATH,3	; page 1
	goto	INTERRUPT	; interrupt continues at page 1 address


; Lookup table
MODE ; converts to required  bits for counter. MODE_VAL is  0-4. after running through MODE lookup, converts to as shown for easier bit manipulation and placed into TEMP_M 
; bit 2 set is for prescaler on, bit 0 for resolution and bit 1 for 10kHz rounding
	addwf	PCL,f
	retlw	B'00000000'	; 0	low resolution
	retlw	B'00000001'	; 1 	high resolution
	retlw	B'00000010'	; 2   10kHz rounding
	retlw	B'00000100'	; 3	Low resolution + prescaler
	retlw	B'00000101'	; 4	High Resolution + prescaler

; main counter gating routine includes a table read for ppm adjustment

TEST ; **** check loops for 100ms using value 20 and 1s using 200 for SAMPLE. ppm value alters timebase by 1ppm per step (0-100 range, 50 no change)
;	movlw	D'200'
;	movwf 	SAMPLE
;	movlw	D'49'
;	movwf	PPM	
; end test

; count the input frequency pulses
CK_CNT
	bcf		PORTB,0		; prevent frequency input to RA4
	bsf		PORTA,2		; enable clocking when RB0 goes high

; prescaler and register reset

	clrf		REG_A		; counter MS byte
	clrf		TIMER		; timer counter storage
	movf	SAMPLE,w	; SAMPLE time  
	movwf	STORE1		; sample time storage

; get fix value
	xorlw	D'20'		; 100ms gating
	movlw	D'19'		; used for 100ms gating
	btfss	STATUS,Z
	movlw	D'241'		; used for 1s gating
	movwf	FIX

	movf	SAMPLE,w	; SAMPLE time  
	xorlw	D'20'		; 100ms gating
	btfss	STATUS,Z
	goto	ONE_SEC_PPM
; 100ms ppm
; process so if PPM=50 keep at 50

	movlw	D'50'
	subwf	PPM,w
	movlw	D'50'
	btfsc	STATUS,Z
	goto	ONE_SEC_PPM		; can be left at 50

; process PWM for 100ms ( ppm /10 limited range)
	movf	PPM,w
	sublw	D'99'		; if greater
	movlw	D'55'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movf	PPM,w
	sublw	D'89'		; if greater
	movlw	D'54'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movf	PPM,w
	sublw	D'79'		; if greater
	movlw	D'53'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movf	PPM,w
	sublw	D'69'		; if greater
	movlw	D'52'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movf	PPM,w
	sublw	D'59'		; if greater
	movlw	D'51'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movf	PPM,w
	sublw	D'41'		; if greater
	movlw	D'50'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movf	PPM,w
	sublw	D'31'		; if greater
	movlw	D'49'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movf	PPM,w
	sublw	D'21'		; if greater
	movlw	D'48'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movf	PPM,w
	sublw	D'11'		; if greater
	movlw	D'47'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movf	PPM,w
	sublw	D'1'		; if greater
	movlw	D'46'		; use
	btfss	STATUS,C
	goto	ONE100ms
	movlw	D'45'
	goto	ONE100ms

ONE_SEC_PPM
; 1s
	movf	PPM,w
ONE100ms
	movwf	PPM_STO	
	clrf		TMR0		; timer (counter) and prescaler reset to zero
	bcf		INTCON,TMR0IF; clear timer overflow bit
; ***** Breakpoint here for test
	bsf		PORTB,0	; start counting frequency at RA4 input
	
; adjustment for ppm. suits +/-50ppm range for 1s

	movf	PPM_STO,w		; 50 is no adjustment, 49 to zero is a longer gating period meaning crystal is fast. 51 to 100 is shorter gating, meaning crystal is slow
	addwf	PCL,f		; ensure there is no 256 byte boundary crossed by checking program line in the list file
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop	
	nop
	nop
	nop
	nop
	nop		; 25
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop	
	nop
	nop
	nop
	nop
	nop		; 50
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop	
	nop
	nop
	nop
	nop
	nop		; 75
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop	
	nop
	nop
	nop
	nop
	nop		; 100
	nop
	nop
	nop
	nop
; end ppm adjust

; get fix value
	movf	FIX,w
	xorlw	D'19'
	btfss	STATUS,Z
	goto	SKIP
	nop					; initial timing adjustment
	nop
	nop
	nop					; initial timing adjustment
	nop
	nop
	nop
SKIP
						; initial timing adjustment
	nop
	nop
	nop					; initial timing adjustment
	nop
	movf	FIX,w		; timer fix value D'19' for 100ms		; 241 for 1s
	movwf	STORE3
CK_CNTW
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	decfsz	STORE3,f
	goto	CK_CNTW	
CK_CNTA
	movlw	D'249'		; D'249'		; delay timing
	movwf	STORE2		; store value in register
CK_CNTB
	btfss	INTCON,TMR0IF; has timer overflowed
	goto	CK_CNTC
	bcf		INTCON,TMR0IF; clear overrange flag
	incfsz	REG_A,f		; increase most significant byte if zero then over
	goto	CK_CNTE
	goto	CK_CNTO		; overrange change range
CK_CNTC
	nop
	nop
	nop
CK_CNTE
	movlw	H'03'		; extra delay	
	movwf	STORE3
	nop
	
CK_CNTD
	decfsz	STORE3,f	; delay loop
	goto	CK_CNTD
	decfsz	STORE2,f
	goto	CK_CNTB
	decfsz	STORE1,f
	goto	CK_CNTA

; end of clock counting
; ***** breakpoint here for test	
	bcf		PORTB,0	; time period ended
	nop					; allow time for TMR0 to clock
	nop
	nop
	nop
	nop					; allow time for TMR0 to clock
	nop
	nop
	nop
	movf	TMR0,w		; get timer value
	movwf	REG_B		; mid significant byte
	btfss	INTCON,TMR0IF; has timer overflowed
	goto	CK_CNTG
	incf		REG_A,f
EOC
CK_CNTG
	clrf		REG_C		; clear ready to get prescaler CK_CNT
	incf		REG_C,f		; adjust up to compensate for decrement next
CK_CNTH
	decf	REG_C,f
	bcf		PORTA,2		; clock TMR0 input
	nop
	nop
	nop
	bsf		PORTA,2
	movf	TMR0,w		; check if TMR0 has changed
	subwf	REG_B,w
	btfsc	STATUS,Z
	goto	CK_CNTH
	clrf		FLAG		; clear flag for 1s gating
	return  

; check if REG_A has overflowed. If so set flag to run 100ms gate instead 

CK_CNTO
	 bsf		FLAG,0		; set flag so to run 100ms gate
	return	
;----------------------------------------------------------------------------------------------------------------------------------------------------------------------

MAIN
	movlw	B'00000000'
	movwf	PORTB		; 
	movwf	PORTA	

; initialise ports
; set inputs/outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'		; comparators off
	movwf	CMCON
	movlw	B'00000110'		; port B outputs at MS bits inputs at LS bits
	movwf	TRISB			; port B data direction register
	movlw	B'11110000'		; I/O
	movwf	TRISA			; port A data direction register
	movlw	B'00110111'		; prescaler external clock and /256, 
	movwf	OPTION_REG	; port B pullups enabled
	clrf		ANSEL			; digital I/O
; pwm set
	movlw	H'FE'
	movwf	PR2				; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	clrf		CCPR1L		; duty 0% 
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	B'00000000'		; if bit 0 is set then prescaler /4. If bit 1 set instead /16
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2

	movlw	B'00001100'		; set PWM mode
	movwf	CCP1CON		; enable PWM operation

	movlw	H'F0'			; start up delay
	call		DELAYXX
	movlw	EEPROM2
	call		EEREAD		; get current value	
	movwf	CCPR1L		; set backlight

	clrf		PORTB
	clrf		DIR				; display brightness direction cleared

; get PPM value	
	movlw	EEPROM3
	call		EEREAD
	movwf	PPM			; PPM value

; **** test gating and ppm calibration
;	goto	TEST	; tests 100ms and 1s gating period using simulator and breakpoints running at 4MHz

; set up initial conditions for display
	
	clrf		PORTA		; RS, E low
	call		DELAY_TM	; 200ms
	call		DELAY_TM	; 200ms

; initialise LCD
	movlw	H'FF'		; start up delay 160ms
	call		DELAYX
	call		INIT_LC	
	movlw	H'FF'		; 160ms delay
	call		DELAYX
	call		INIT_LC
	call		DELAYms	; 12ms
	call		INIT_LC
	call		DELAYms
	call		INIT_LC
	call		DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call		LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call		LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	movlw	B'00000001'	; display clear
	call		LOAD
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call		LOAD

; initialise LCD
	movlw	H'FF'		; start up delay 160ms
	call		DELAYX
	call		INIT_LC	
	movlw	H'FF'		; 160ms delay
	call		DELAYX
	call		INIT_LC
	call		DELAYms	; 12ms
	call		INIT_LC
	call		DELAYms
	call		INIT_LC
	call		DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call		LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call		LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	movlw	B'00000001'	; display clear
	call		LOAD
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call		LOAD

; initialise LCD
	movlw	H'FF'		; start up delay 160ms
	call		DELAYX
	call		INIT_LC	
	movlw	H'FF'		; 160ms delay
	call		DELAYX
	call		INIT_LC
	call		DELAYms	; 12ms
	call		INIT_LC
	call		DELAYms
	call		INIT_LC
	call		DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call		LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call		LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	movlw	B'00000001'	; display clear
	call		LOAD
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call		LOAD

	call		CLEAR
	goto	BY_CLR1

CLEAR ; clear values
	movlw	A'0'			; ASCII 0
	movwf	ESEVN		; ms display digit to zero
	movwf	ESIX
	movwf	EFIVE
	movwf	EFOUR
	movwf	ETHREE
	movwf	ETWO
	movwf	EONE
	movwf	EZERO		; ls display digit to 0
	call		DISP_L		; load Hz on display
	return

BY_CLR1
; check if switches pressed at power up
	btfss	PORTB,1	; Brightness switch; if low then adjust ppm value
	goto	PPM_ADJ

	btfsc	PORTB,2	; Resolution switch, if low run clock
	goto	BACK_LIGHT
	bsf		PCLATH,3	; page for H'800'
	goto	CLOCK

BACK_LIGHT
; check backlight pressing

	btfsc	PORTB,1	; check backlight switch. Change when low
	goto	RESOL

LOOP_B ; brightness loop
	movlw	D'160'		; 100ms delay with 4 MHz clock
	call		DELAYX

; check if switch open
	btfsc	PORTB,1
	goto	STORE_B
; check direction
	btfss	DIR,0
	goto	INC_B
; decrease brightness
; in steps of 5
	movlw	D'5'
	movwf	RATE
LOOP_D ; down in brightness loop	
	movf	CCPR1L,w
	btfss	STATUS,Z	; stop at 0
	decf	CCPR1L,f
	decfsz	RATE,f		; reduce rate value till zero
	goto	LOOP_D	; loop for down in brightness
	goto	LOOP_B

INC_B ; increase brightness
; in steps of 5
	movlw	D'5'
	movwf	RATE
LOOP_I	;  increase  PWM in brightness loop
	movf	CCPR1L,w
	xorlw	H'FF'	
	btfss	STATUS,Z	; stop at FF
	incf		CCPR1L,f
	decfsz	RATE,f		; reduce rate value till zero
	goto	LOOP_I		; loop for up in brightness
	goto	LOOP_B

STORE_B
	incf		DIR,f		; change dimming direction
	movlw	EEPROM2
	call		EEREAD	; sets EEADR
	movf	CCPR1L,w
	call		EEWRITE	

RESOL ; resolution
	clrf		FLAG_S
	btfsc	PORTB,2	; is RB2 high (switch open) or low with switch closed
	goto	CK_EEP
	movlw	EEPROM1
	call		EEREAD	; get current resolution
	movwf	MODE_VAL
	
; if at count of 4, clear MODE_VAL

	movf	MODE_VAL,w
	sublw	D'03'
	movlw	H'FF'		
	btfss	STATUS,C
	movwf	MODE_VAL	; when at 4, clear (FF + 1=0)
	incf		MODE_VAL,w
	movwf	MODE_VAL
	call		EWRITE
	movf	MODE_VAL,w
	call		MODE		; convert
	movwf	TEMP_M
	call		RES_DSP	; resolution display

SW_CK
	call		DELAY_TM	; 200ms
	btfss	PORTB,2	; is switch released
	goto	SW_CK
	movlw	B'00000001'	; display clear
	call		LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call		LOAD
	call		CLEAR		; clear display registers

CK_EEP
	movlw	EEPROM1
	call		EEREAD
	movwf	MODE_VAL
	call		MODE		; convert
	movwf	TEMP_M

; set Timer0 to count  input signal 
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00110111'		; prescaler external clock and /256, 
	movwf	OPTION_REG	; port B pullups enabled
	bcf		STATUS,RP0	; select memory bank 0	

	btfsc	TEMP_M,0	; if clear then 100ms gate
	goto	RANGE2
	goto	RANGE1B

RANGE1
	call		DELAY_TM	; slow down update to 200ms for 100ms gating as LCD too slow for faster changes

	goto	BACK_LIGHT
	
; select resolution 10Hz, 1Hz  (100ms or 1s gating)
	
RANGE1B
	movlw	D'20'		; 100ms gate 
	movwf	SAMPLE	; count period
	call		CK_CNT	; count clock input frequency signal
	call		BIN_BCD	; convert binary to BCD and ASCII

; check range		

	movf	ESIX,w		; ms digit for 100ms gate period
	xorlw	H'30'		; ASCII 0
	btfss	STATUS,Z	; if not zero then MHz
	goto	MHz10		; MHz range 10Hz resolution
	movf	EFIVE,w		; next MHz digit for 100ms gate period
	xorlw	H'30'		; ASCII 0
	btfss	STATUS,Z	; if not zero then MHz range
	goto	MHz10		; MHz range 10Hz resolution
	movf	EFOUR,w	; kHz ms digit
	xorlw	H'30'
	btfss	STATUS,Z	; if not zero then kHz
	goto	kHz10
	movf	BCD4,w		; check packed BCD value for Ethree and Etwo
	btfss	STATUS,Z	; if zero then Hz1 range
	goto	kHz10		; kHz range 10Hz resolution
	call		Hz1
	goto	BACK_LIGHT

; MHz range 10Hz resolution

MHz10
	btfsc	TEMP_M,1	; when set 10kHz rounding
	goto	MHz10_ROUNDING
MHz10_BY
	movlw	B'10000001'	; set display address 1
	call		LOAD
	call		SPACE1		; clear ms digit
	movlw	H'02'		; output first 2 characters
	movwf	STOREX
	movlw	ESIX		; MSD of freq
	movwf	FSR

MRNG2
	movlw	H'30'		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	MRNG3
	call		SPACE1	; 1 space
	incf		FSR,f		; EFIVE
	decfsz	STOREX,f
	goto	MRNG2
	goto	MRNG4
MRNG3
	movf	INDF,w		; display ESIX
	call		DRV_LCD
	incf		FSR,f		; EFOUR
	decfsz	STOREX,f
	goto	MRNG3
MRNG4
	movlw	H'2E'		; ASCII for a dot
	call		DRV_LCD
	movlw	H'05'		;   characters
	movwf	STOREX	
MRNG5
	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f		; ETHREE, ETWO etc
	decfsz	STOREX,f
	goto	MRNG5
	call		SPACE1	; 1 space

; if TEMP_M,2 high and TEMP_M bit1 low change MHz to GHz
	btfsc	TEMP_M,1		; no prescaler for rounding  
	goto	NO_PRESCALER_MHz
	btfss	TEMP_M,2		; bit 2 is for prescaler when set
	goto	NO_PRESCALER_MHz
; GHz
	movlw	A'G'		;  'G'
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2	; 2 spaces
	call		PRESCALER_WRITE
	goto	RANGE1

NO_PRESCALER_MHz	
	movlw	A'M'		; ASCII M
	call	DRV_LCD
DV_Hz
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2	; 2 spaces
	movlw	H'C0'	; display address line2
	call	LOAD
	call	SPACE4	; remove second line
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	goto	RANGE1

; MHz range 10Hz resolution
MHz10_ROUNDING

; check if 36MHz or over
; 4 or more in most significant digit (if a 4 then >36 anyway)
	movf	ESIX,w
	sublw	H'33'		; 3 ASCII
	btfss	STATUS,C
	goto	DO_ROUNDING
; 3  in most significant digit (if a 3 then  check for a 6 or more in next digit)
	movf	ESIX,w
	sublw	H'32'		; 2 ASCII
	btfsc	STATUS,C
	goto	MHz10_BY
; check if 6 or more in next most significant digit
	movf	EFIVE,w
	sublw	H'35'		; 5 ASCII
	btfsc	STATUS,C
	goto	MHz10_BY

DO_ROUNDING

; rounding, strip out ASCII bits first
	movf	EZERO,w	; ls byte
	andlw	H'0F'		; strip ASCII bit
	movwf	EZERO

	movf	EONE,w		; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	EONE

	movf	ETWO,w		; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	ETWO

	movf	ETHREE,w	; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	ETHREE

	movf	EFOUR,w	; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	EFOUR

	movf	EFIVE,w		; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	EFIVE

	movf	ESIX,w		; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	ESIX


; check for a five
; EZERO
	movf	EZERO,w	
	sublw	D'04'		; if five or > five increase EONE
	btfsc	STATUS,C
	goto	CK_ONE

; over 5 for EZERO
	incf		EONE,f		; one more
	movf	EONE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE
; set at 0
	clrf		EONE

	incf		ETWO,f
	movf	ETWO,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE
; set at 0
	clrf		ETWO	

	incf		ETHREE,f
	movf	ETHREE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE
; set at 0
	clrf		ETHREE

	incf		EFOUR,f
	movf	EFOUR,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE
; set at 0
	clrf		EFOUR

	incf		EFIVE,f
	movf	EFIVE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE
; set at 0
	clrf		EFIVE

	incf		ESIX,f		; 
	
CK_ONE; EONE
	movlw	H'30'		; ASCII 0
	movwf	EZERO		; EZERO cleared
	
	movf	EONE,w		; next byte	
	sublw	D'04'		; if five or > five increase ETWO
	btfsc	STATUS,C
	goto	CK_TWO

; over 5 for EONE

	incf		ETWO,f
	movf	ETWO,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_TWO
; set at 0
	clrf		ETWO
	
	incf		ETHREE,f
	movf	ETHREE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_TWO
; set at 0
	clrf		ETHREE

	incf		EFOUR,f
	movf	EFOUR,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_TWO
; set at 0
	clrf		EFOUR

	incf		EFIVE,f
	movf	EFIVE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_TWO
; set at 0
	clrf		EFIVE

	incf		ESIX,f	

CK_TWO ; ETWO

	movlw	H'30'		; ASCII 0
	movwf	EONE		; EONE cleared
	
	movf	ETWO,w		; next byte	
	sublw	D'04'		; if five or > five increase ETHREE
	btfsc	STATUS,C
	goto	CK_THREE

; over 5 for ETWO

	incf		ETHREE,f
	movf	ETHREE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_THREE
; set at 0
	clrf		ETHREE

	incf		EFOUR,f
	movf	EFOUR,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_THREE
; set at 0
	clrf		EFOUR

	incf		EFIVE,f
	movf	EFIVE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_THREE
; set at 0
	clrf		EFIVE

	incf		ESIX,f	

CK_THREE
	movlw	H'30'		; ASCII 0
	movwf	ETWO		; ETWO cleared

; restore ASCII to 3,4,5,6
	movlw	H'30'
	iorwf	ETHREE,f
	iorwf	EFOUR,f
	iorwf	EFIVE,f
	iorwf	ESIX,f

; display value
			
	movlw	B'10000001'	; set display address 1
	call		LOAD
	call		SPACE1		; clear ms digit
	movlw	H'02'		; output first 2 characters
	movwf	STOREX
	movlw	ESIX		; MSD of freq
	movwf	FSR

MRNG2R
	movlw	H'30'		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	MRNG3R
	call		SPACE1		; 1 space
	incf		FSR,f		; EFIVE
	decfsz	STOREX,f
	goto	MRNG2R
	goto	MRNG4R
MRNG3R
	movf	INDF,w		; display ESIX
	call		DRV_LCD
	incf		FSR,f		; EFOUR
	decfsz	STOREX,f
	goto	MRNG3R
MRNG4R
	movlw	H'2E'		; ASCII for a dot
	call		DRV_LCD
	movlw	H'03'		; 3 characters
	movwf	STOREX	
MRNG5R
	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f		; ETHREE, ETWO etc
	decfsz	STOREX,f
	goto	MRNG5R
	call		SPACE1	; 1 space
	movlw	A'M'			; ASCII M
	call		DRV_LCD
DV_HzR
	movlw	A'H'		; H
	call		DRV_LCD
	movlw	A'z'		; z
	call		DRV_LCD
	call		SPACE2		; 2 spaces
	
; display 10kHz Rounding

	movlw	H'C0'		; display address line2
	call	LOAD
	movlw	A'('		; (
	call	DRV_LCD
	movlw	A'1'		; 1
	call	DRV_LCD
	movlw	A'0'		; 0
	call	DRV_LCD
	movlw	A'k'		; k
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE1
	movlw	A'R'		; Rounding
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'u'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'g'		; 
	call	DRV_LCD
	movlw	A')'		; )
	call	DRV_LCD
	call	SPACE2
	goto	RANGE1

; kHz range 10Hz resolution

kHz10
	movlw	H'81'		; display address 1
	call		LOAD
	call		SPACE1	; clear digit
	movlw	H'05'		; first 3 characters
	movwf	STOREX
	movlw	ESIX		; MSD of freq for kHz
	movwf	FSR
kHz2
	movlw	H'30'		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	kHz3
	call		SPACE1	; 0's to space
	incf		FSR,f
	decfsz	STOREX,f
	goto	kHz2
	goto	kHz4
kHz3
	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f
	decfsz	STOREX,f
	goto	kHz3
kHz4
	movlw	H'2E'		; dot
	call		DRV_LCD
	movf	INDF,w		; last 2 characters
	call		DRV_LCD
	incf		FSR,f
	movf	INDF,w
	call		DRV_LCD
	call		SPACE1		; 1 space

; if TEMP_M bit 2 set and  bit1 low change kHz to MHz
	btfsc	TEMP_M,1		; no prescaler for rounding  
	goto	NO_PRESCALER_kHz
	btfss	TEMP_M,2		; set so prescaler units
	goto	NO_PRESCALER_kHz
; MHz
	movlw	A'M'		; ASCII 'M'
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	call		PRESCALER_WRITE
	goto	RANGE1

NO_PRESCALER_kHz
	movlw	A'k'		; k
	call		DRV_LCD
	goto	DV_Hz

; Hz range 1 second gate 1Hz resolution 

Hz1	movlw	D'200'		; 1s SAMPLE
	movwf	SAMPLE
	call		CK_CNT
	call		BIN_BCD		; convert binary to BCD
	
DISP_L
	movlw	H'81'		; address
	call		LOAD
	call		SPACE2	; 2 spaces
	movlw	H'06'		; first 6 characters
	movwf	STOREX
	movlw	ESIX		; MSD of freq
	movwf	FSR
Hz4	movlw	H'30'		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	Hz2
	call		SPACE1		; leading 0's to space
	incf		FSR,f
	decfsz	STOREX,f
	goto	Hz4
	goto	Hz3
Hz2	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f
	decfsz	STOREX,f
	goto	Hz2
Hz3	movf	INDF,w
	call		DRV_LCD

; if TEMP_M,2 set and TEMP_M bit1 low change Hz to kHz
	btfsc	TEMP_M,1		; no prescaler for rounding  
	goto	NO_PRESCALER_Hz
	btfss	TEMP_M,2		; set so prescaler units
	goto	NO_PRESCALER_Hz
; kHz
	call	SPACE1
	movlw	A'k'		; ASCII 'k'
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	call		PRESCALER_WRITE
	return

NO_PRESCALER_Hz
	call	SPACE2		; 2 spaces
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces 
	movlw	H'C0'		; display address line2
	call	LOAD
	call	SPACE4		; remove second line
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	return

; select resolution 1Hz, 0.1Hz. Determine gating depending upon setting

RANGE2
	movlw	D'200'		; 1s gate period
	movwf	SAMPLE	; count period
	call		CK_CNT	; count clock input frequency signal
	btfsc	FLAG,0		; if flag set then overrange
	goto	RANGE1B	; 100ms range
	call		BIN_BCD	; convert binary to BCD and ASCII

; check range		

	movf	BCD2,w		; ms BCD digit for 1s gate period
	btfss	STATUS,Z	; if not zero then MHz
	goto	MHz1		; MHz range 1Hz resolution

	movf	BCD3,w		; kHz ms BCD digits
	btfss	STATUS,Z	; if not zero then kHz1
	goto	kHz1
	movf	ETHREE,w	; ASCII for Ethree 
	xorlw   	H'30'		; ASCII 0
	btfss	STATUS,Z	; if not zero then kHz1 range
	goto	kHz1		; kHz range 1Hz resolution
	goto	HZ_PT1
	goto	BACK_LIGHT		; resolution

; MHz range 1Hz resolution

MHz1
	movlw	B'10000001'	; set display address 1
	call		LOAD
	movlw	H'02'		; output first 2 characters
	movwf	STOREX
	movlw	ESEVN		; MSD of freq
	movwf	FSR
MRN2
	movlw	H'30'		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	MRN3
	call		SPACE1	; ASCII space. 0's to space
	incf		FSR,f		; ESIX
	decfsz	STOREX,f
	goto	MRN2
	goto	MRN4
MRN3
	movf	INDF,w		; display ESEVN
	call		DRV_LCD
	incf		FSR,f		; ESIX
	decfsz	STOREX,f
	goto	MRN3
MRN4
	movlw	H'2E'		; ASCII for a dot
	call		DRV_LCD
	movlw	H'06'		; 6 characters
	movwf	STOREX	
MRN5
	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f		; ETHREE, ETWO etc
	decfsz	STOREX,f
	goto	MRN5
	call		SPACE1		; 1 space

; if TEMP_M,2 high and TEMP_M bit1 low change MHz to GHz
	btfsc	TEMP_M,1		; no prescaler for rounding  
	goto	NO_PRESCALER_Hz1
	btfss	TEMP_M,2		; set so prescaler units
	goto	NO_PRESCALER_Hz1
; GHz
	movlw	A'G'		; ASCII 'G'
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	call		PRESCALER_WRITE
	goto	BACK_LIGHT

NO_PRESCALER_Hz1
	movlw	A'M'		; M
	call	DRV_LCD
DV_Hz1
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	H'C0'		; display address line2
	call	LOAD
	call	SPACE4		; remove second line
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	goto	BACK_LIGHT

; kHz range 1Hz resolution

kHz1
	movlw	H'81'		; display address 1
	call		LOAD
	movlw	H'05'		; first 3 characters
	movwf	STOREX
	movlw	ESEVN		; MSD of freq for kHz
	movwf	FSR
k1z2
	movlw	H'30'		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	k1z3
	call		SPACE1		; 0's to space
	incf		FSR,f
	decfsz	STOREX,f
	goto	k1z2
	goto	k1z4
k1z3
	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f
	decfsz	STOREX,f
	goto	k1z3
k1z4
	movlw	H'2E'		; dot
	call		DRV_LCD
	movf	INDF,w		; last 3 characters
	call		DRV_LCD
	incf		FSR,f
	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f
	movf	INDF,w
	call		DRV_LCD
	call		SPACE1		; 1 space

; if TEMP_M,2 and TEMP_M bit1 low change kHz to MHz
	btfsc	TEMP_M,1		; no prescaler for rounding  
	goto	NO_PRESCALER_kHz1
	btfss	TEMP_M,2		; set so prescaler units
	goto	NO_PRESCALER_kHz1
; MHz
	movlw	A'M'		; ASCII 'M'
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	call		PRESCALER_WRITE
	goto	BACK_LIGHT

PRESCALER_WRITE
	movlw	H'C0'		; display address line2
	call	LOAD

	movlw	A'U'		; Units for 1000:1 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A's'		;
	call	DRV_LCD
	call	SPACE1
	movlw	A'f'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'1'		;
	call	DRV_LCD
	movlw	A'0'		; 
	call	DRV_LCD
	movlw	A'0'		; 
	call	DRV_LCD
	movlw	A'0'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
	movlw	A'1'		; 
	call	DRV_LCD
	return

NO_PRESCALER_kHz1
	movlw	A'k'		; k
	call	DRV_LCD
	goto	DV_Hz1

; Hz at 0.1 Hz resolution

HZ_PT1
	clrf		FLAG_1
	clrf		REG_A			; MS counter
	clrf		REG_B
	clrf		REG_C			; LS counter
	bcf		PORTB,0		; prevent frequency input to RA4
	bsf		PORTA,2		; enable clocking when RB0 goes high
	bsf		PORTB,0		; start input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00010111'		; prescaler internal clock and /256, 
	movwf	OPTION_REG	; 
	bcf		STATUS,RP0	; memory bank 0	
	bcf		INTCON,TMR0IF	; clear timer overflow bit

WAIT
	btfss	INTCON,TMR0IF; has timer overflowed
	goto	C_FLG	
	bcf		INTCON,TMR0IF
	incfsz	REG_A,f
	goto	CK_1Hz
	call		OVER		; clear display no input or too low
	goto	BACK_LIGHT
CK_1Hz
	btfsc	FLAG_S,0	; bypass await signal 
	goto	C_FLG
	movf	REG_A,w
	xorlw	H'0F'		; almost 1 second
	btfss	STATUS,Z	; if 0 then ~ 1 second
	goto	C_FLG
	call		SIGNAL
	bsf		FLAG_S,0	; set flag when await signal displayed
	goto	HZ_PT1	
C_FLG
	btfsc	FLAG_1,1	; has counter sequence started
	goto	COUNT_P	; count positive edge start

	btfss	PORTB,2	; is mode switch pressed
	goto	RESOL
	btfss	PORTB,1	; is backlight switch pressed
	goto	BACK_LIGHT

CON_SQ	

	btfss	FLAG_1,3	; if flag set then set flag_1,1 when RA4 high
	goto	CHK_LOW
	btfsc	PORTA,4	; is RA4 high
	bsf		FLAG_1,1
	goto	WAIT

CHK_LOW
	btfss	PORTA,4	; is RA4 low
	bsf		FLAG_1,3	; set flag when RA4 is low
	goto	WAIT

; increment counters

COUNT_P
	clrf		TMR0		; timer (counter) and prescaler reset to zero
	clrf		TIMER		; timer counter storage
	clrf		REG_A		; MS counter

; start TMR0

	bcf		INTCON,TMR0IF; clear timer overflow bit	
COUNT_T
	btfss	INTCON,TMR0IF; is timer overflowed
	goto	CK_END
	incfsz	REG_A,f		; increase most significant byte (if zero then over)
	goto	CLR_T
	call		OVER		; overrange
	goto	BACK_LIGHT
CLR_T
	bcf		INTCON,TMR0IF; clear timer overflow bit
CK_END
	btfsc	FLAG_1,2	; is flag 2 set
	goto	CK_HI
	btfss	PORTA,4	; is porta,4 low again
	bsf		FLAG_1,2	; set flag when low
	goto	COUNT_T	; continue counting
CK_HI
	btfss	PORTA,4	; is it high again
	goto	COUNT_T		;

; stop TMR0

	bcf		PORTB,0	; prevent frequency input to RA4
; stop counting
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00110111'		; prescaler external clock and /256, 
	movwf	OPTION_REG	; 
	bcf		STATUS,RP0	; memory bank 0	
	btfss	INTCON,TMR0IF; is timer overflowed
	goto	NOT_O
	incfsz	REG_A,f		; increase most significant byte (if zero then over)
	goto	NOT_O
	goto	OVER		; overrange
NOT_O
	movf	TMR0,w		; get timer value
	movwf	REG_B		; mid significant byte
	call		EOC		; convert TMR0 and prescaler to REG values

; check if frequency  >100Hz

	movf	REG_A,w	; ms byte
	btfss	STATUS,Z	; if zero check other numbers
	goto	BELOW	
	movlw	H'27'		; ms byte H'2700'.
	subwf	REG_B,w
	btfsc	STATUS,C
	goto	BELOW
	call		Hz1			; 1Hz resolution
	goto	BACK_LIGHT		; check resolution
BELOW
	movf	REG_A,w
	movwf	BARGB0
	movf	REG_C,w		; end of count so process
	movwf	BARGB2
	movf	REG_B,w
	movwf	BARGB1
	movlw	H'98'		; hex for 10,000,000
	movwf	AARGB0
	movlw	H'96'		; hex for 10,000,000
	movwf	AARGB1
	movlw	H'80'		; hex for 10,000,000
	movwf	AARGB2
	call		FXD2424U	; divide into 10,000,000
	movf	AARGB0,w
	movwf	BIN3
	movf	AARGB1,w
	movwf	BIN2
	movf	AARGB2,w
	movwf	BIN1
	call		BINBCDX	; convert binary to BCD
	
INST
	movlw	H'81'		; address
	call		LOAD
	call		SPACE1	; 1 space
	movlw	H'07'		; first 7 characters
	movwf	STOREX
	movlw	ESEVN		; MSD of freq
	movwf	FSR
HzPT4
	movlw	H'30'		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	HzPT2
	call		SPACE1		; leading 0's to space
	incf		FSR,f
	decfsz	STOREX,f
	goto	HzPT4
	goto	HzPT3
HzPT2
	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f
	decfsz	STOREX,f
	goto	HzPT2
HzPT3
	movlw	H'2E'		; dot
	call		DRV_LCD
	movf	INDF,w
	call		DRV_LCD
	call		SPACE1

; if TEMP_M,2 high and TEMP_ML bit1 low change Hz to kHz
	btfsc	TEMP_M,1		; no prescaler for rounding  
	goto	DV_Hz1
	btfss	TEMP_M,2		; set so prescaler units
	goto	DV_Hz1
	movlw	A'k'		; ASCII 
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	call		PRESCALER_WRITE
	goto	BACK_LIGHT	

; overrange display

SIGNAL
	movlw	H'01'		; clear display
	call	LOAD
	movlw	H'02'		; cursor home
	call	LOAD
		
	movlw	H'82'		; display address
	call	LOAD
	movlw	A'A'		; A
	call	DRV_LCD
	movlw	A'w'		; w
	call	DRV_LCD
	movlw	A'a'		; a
	call	DRV_LCD
	movlw	A'i'		; i
	call	DRV_LCD
	movlw	A't'		; t
	call	DRV_LCD
	goto	SIG_SP	 	; display 'signal'

OVER
OVER_D
	movlw	H'01'		; clear display
	call	LOAD
	movlw	H'02'		; cursor home
	call	LOAD
	call	SPACE1		; 1 space		
	movlw	H'83'		; display address
	call	LOAD
	movlw	A'N'		; N
	call	DRV_LCD
	movlw	A'o'		; o
	call	DRV_LCD
SIG_SP
	call	SPACE1		; space
	movlw	A'S'		; S
	call	DRV_LCD
	movlw	A'i'		; i
	call	DRV_LCD
	movlw	A'g'		; g
	call	DRV_LCD
	movlw	A'n'		; n
	call	DRV_LCD 
	movlw	A'a'		; a
	call	DRV_LCD
	movlw	A'l'		; l
	call	DRV_LCD
	call	SPACE4		; 4 spaces
	call	SPACE4
	movlw	H'C0'		; display address line2
	call	LOAD
	call	SPACE4		; remove second line
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	return

; resolution display

RES_DSP
	movlw	H'01'		; clear display
	call		LOAD
	movlw	H'02'		; cursor home
	call		LOAD
	call		CLEAR		; clear display registers
	movlw	B'11000000'	; display address first column second line
	call		LOAD
	btfss	TEMP_M,0		; check resolution
	goto	ONEHZ
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'i'		; i
	call	DRV_LCD
	movlw	A'g'		; g
	call	DRV_LCD
	movlw	A'h'		; h
	call	DRV_LCD
	call	SPACE1
	goto	PRESCALER?
	
ONEHZ
; if rounding show instead of LOW
	btfsc	TEMP_M,1		; check rounding
	goto	DO_ROUNDING_DSP
	movlw	A'L'		; L
	call	DRV_LCD
	movlw	A'o'		; o
	call	DRV_LCD
	movlw	A'w'		; w
	call	DRV_LCD
	call	SPACE1	; one space

PRESCALER?

; check if prescaler
	btfss	TEMP_M,2		; set so show prescaler
	goto	NONE
	movlw	A'R'		; 
	call	DRV_LCD 
	call	SPACE1
	movlw	A'P'		; Prescaler
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD 
	movlw	A'c'		; 
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD 
	call	SPACE2
	return
NONE
; write resolution
	movlw	A'R'		; Resolution
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD 
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'u'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD 
	movlw	A'n'		; 
	call	DRV_LCD 
	call	SPACE2
	return

DO_ROUNDING_DSP
	movlw	A'R'		; Rounding
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'u'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'g'		; 
	call	DRV_LCD

	call 	SPACE1
	movlw	A'@'	; @
	call	DRV_LCD
	movlw	A'>'		; >36MHz
	call	DRV_LCD
	movlw	A'3'		; 3
	call	DRV_LCD
	movlw	A'6'		; 6
	call	DRV_LCD
	movlw	A'M'		; M
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE1
	
	return
;***************************************************************************
; subroutines

; add space in display

SPACE4
	movlw	H'20'		; space
	call	DRV_LCD
SPACE3
	movlw	H'20'		; space
	call	DRV_LCD
SPACE2
	movlw	H'20'		; space
	call	DRV_LCD
SPACE1
	movlw	H'20'		; space
	call	DRV_LCD
	return

; delay timer

DELAY_TM; 200ms
	movlw	H'0F'
	movwf	TIME_I		; initial timer 
TIM_CON
	call		DELAYms
	decfsz	TIME_I,f
	goto	TIM_CON		; continue timer
	
; nominal 12ms delay loop

DELAYms
	movlw	D'23'		; 12ms delay with 4 MHz clock
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP1
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return


DELAY1 ; 1ms
	movlw	D'2'		; delay value
DELAYXX
	movwf	STORE1		; STORE1 is number of loops value
LOOPA	
	movlw	D'165'
	movwf	STORE2		; STORE2 is internal loop value	
LOOPB
	decfsz	STORE2,f
	goto	LOOPB
	decfsz	STORE1,f
	goto	LOOPA		; decrease till STORE1 is zero
	return

; preload display commands (4-bit) 

LOAD
	movwf	D_STO		; store data	
	movf	D_STO,w
	andlw	H'F0'		; get upper bits
	movwf	PORTB		; place display commands in portB
	bcf		PORTA,1	; register select low
	nop
	bsf		PORTA,0	; enable set
	nop
	bcf		PORTA,0	; enable clear

	swapf	D_STO,w
	andlw	H'F0'		; get lower bits
	movwf	PORTB		; place display commands in portB

	bcf		PORTA,1	; register select low
	nop
	bsf		PORTA,0	; enable set
	nop
	bcf		PORTA,0	; enable clear
	call		BUS_CK	; check busy flag
	return

; driving the LCD module with display data

DRV_LCD
	movwf	D_STO		; store data
	movf	D_STO,w
	andlw	H'F0'		; upper bits	
	movwf	PORTB		; w to portb
	bsf		PORTA,1	; register select
	nop
	bsf		PORTA,0	; enable high
	nop
	bcf		PORTA,0	; enable low

	swapf	D_STO,w
	andlw	H'F0'		; lower bits
	movwf	PORTB		; w to portb
	bsf		PORTA,1	; register select
	nop
	bsf		PORTA,0	; enable high
	nop
	bcf		PORTA,0	; enable low
	call		BUS_CK	; check busy flag
	return

; check busy flag (add delay instead)

BUS_CK
	movlw	H'02'		; delay to ensure busy flag is clear
	movwf	STORE1
	movlw	D'255'		; delay for busy flag to clear
	goto	DELDSP


; initialise display

INIT_LC
	movlw	B'00110000'	; DB4 and DB5 high  to initialise module
	movwf	PORTB
	bcf		PORTA,1
	nop
	bsf		PORTA,0		; enable high
	nop
	bcf		PORTA,0		; low
	return


; Subroutine BCD (to convert 28-bit binary to 8-digit BCD)
; Binary value is in BIN1, BIN2, BIN3 & BIN4. BIN1 is LSB, BIN4 is MSB
; Result in BCD is in BCD1, BCD2, BCD3, BCD4 & BCD5. BCD1 is for overrange, 
; BCD2 is MSB, BCD5 is LSB

BIN_BCD
	movf	REG_A,w	; ms byte of frequency count
	movwf	BIN3		; next ms byte
	movf	REG_B,w
	movwf	BIN2
	movf	REG_C,w	; ls byte of counter
	movwf	BIN1
BINBCDX
	clrf		BIN4		; ms byte
CAL_CONV
	bcf		STATUS,C	; clear carry bit

	movlw	D'32'
	movwf	COUNT		; 32 in count
	clrf		BCD1		; set BCD registers to 0 
	clrf		BCD2
	clrf		BCD3
	clrf		BCD4
	clrf		BCD5

LOOPBCD
	rlf		BIN1,f		; LSB shift left binary registers
	rlf		BIN2,f
	rlf 		BIN3,f
	rlf		BIN4,f		; MSB
	rlf		BCD5,f		; LSB shift left BCD registers
	rlf		BCD4,f
	rlf		BCD3,f
	rlf		BCD2,f
	rlf		BCD1,f		; MSB

	decfsz	COUNT,f		; reduce count value return when 0
	goto	DECADJ	; continue decimal adjust
	
; result in BCD1-5. (BCD1 overrange, BCD2 MS byte)

	swapf	BCD2,w		; get ms nibble
	andlw	H'0F'
	iorlw	H'30'		; convert to ASCII
	movwf	ESEVN		; ms digit
	movf	BCD2,w		; get 2nd ms nibble
	andlw	H'0F'
	iorlw	H'30'		; convert to ASCII
	movwf	ESIX

	swapf	BCD3,w		; get next nibble
	andlw	H'0F'
	iorlw	H'30'		; convert to ASCII
	movwf	EFIVE		; ms digit
	movf	BCD3,w		; get next nibble
	andlw	H'0F'
	iorlw	H'30'		; convert to ASCII
	movwf	EFOUR
	
	swapf	BCD4,w		; get ms nibble
	andlw	H'0F'
	iorlw	H'30'		; convert to ASCII
	movwf	ETHREE		; ms digit
	movf	BCD4,w		; get 2nd ms nibble
	andlw	H'0F'
	iorlw	H'30'		; convert to ASCII
	movwf	ETWO

	swapf	BCD5,w		; get ms nibble
	andlw	H'0F'
	iorlw	H'30'		; convert to ASCII
	movwf	EONE		; ms digit
	movf	BCD5,w		; get 2nd ms nibble
	andlw	H'0F'
	iorlw	H'30'		; convert to ASCII
	movwf	EZERO
	return				; completed decimal to BCD operation

; subroutine decimal adjust

DECADJ
	movlw	BCD5		; BCD LSB address
	movwf	FSR			; pointer for BCD5
	call	ADJBCD		; subroutine to adjust BCD
	movlw	BCD4
	movwf	FSR
	call 	ADJBCD
	movlw	BCD3
	movwf	FSR
	call 	ADJBCD
	movlw	BCD2
	movwf	FSR
	call 	ADJBCD
	movlw	BCD1
	movwf	FSR
	call 	ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD

ADJBCD
	movlw	H'03'		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 1-5)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	H'30'		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine

; subroutine to read EEPROM memory 

EEREAD
	bcf		STATUS,RP0	; select bank 0
	bsf 		STATUS,RP1	; select memory bank 2
	movwf 	EEADR			; indirect special function register
	bsf 		STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD		; read EEPROM
	bcf 		STATUS,RP0	; select memory bank 2
	movf	EEDATA,w		; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bcf 		STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 		STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE		; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'			; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'			; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
;	bsf 		INTCON,GIE		; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE			; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 		STATUS,RP0	; select memory bank 0
	return					; value written 

; _________________________________________________________________________
; adjust PPM

PPM_ADJ;
	clrf		START	; start flag
PPM_ADJ1	

; Hz range 1 second gate 1Hz resolution 

Hz1_PPM
	movlw	D'200'		; 1s SAMPLE
	movwf	SAMPLE
	call		CK_CNT
	call		BIN_BCD		; convert binary to BCD
	
DISP_L_PPM
	movlw	H'81'		; address
	call		LOAD
	call		SPACE2	; 2 spaces
	movlw	H'07'		; first 6 characters
	movwf	STOREX
	movlw	ESEVN		; MSD of freq
	movwf	FSR
Hz4_PPM
	movlw	H'30'		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	Hz2_PPM
	call		SPACE1		; leading 0's to space
	incf		FSR,f
	decfsz	STOREX,f
	goto	Hz4_PPM
	goto	Hz3_PPM
Hz2_PPM
	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f
	decfsz	STOREX,f
	goto	Hz2_PPM
Hz3_PPM
	movf	INDF,w
	call		DRV_LCD

	call	SPACE2		; 2 spaces
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE4		;  spaces 

	call		CAL_WRITE_DSP
	goto	SW_ENTRY

; subroutine_______________________________________________________________
CAL_WRITE_DSP
	movlw	H'C0'		; display address line2
	call	LOAD

	movlw	A'C'			;Calibrate
	call	DRV_LCD
	movlw	A'a'			;
	call	DRV_LCD
	movlw	A'l'			;
	call	DRV_LCD
	movlw	A'.'			;
	call	DRV_LCD
	call	SPACE1
	movlw	A'<'		; 
	call	DRV_LCD
; show value	
	clrf		SIGNX
	movf	PPM,w
; ranges from 0 to 100. 50 is 0ppm change
; if 50 set at 0
	sublw	D'50'
	btfss	STATUS,Z
	goto	CK_OVR
	movwf	BIN1
	clrf		BIN2
	clrf		BIN3
	clrf		BIN4
	call		CAL_CONV	;  converts to BCD and ASCII 
	call		SPACE1	;  no sign (+ or -)
	goto	E_SIGN
CK_OVR
; check for over 50
	movlw	D'50'
	subwf	PPM,w
	btfsc	STATUS,C
	goto	LD_PPM
	movf	PPM,w
	sublw	D'50'
	bsf		SIGNX,0
LD_PPM
	movwf	BIN1
	clrf		BIN2
	clrf		BIN3
	clrf		BIN4
	call		CAL_CONV	;  converts to BCD and ASCII 
; check sign
	btfss	SIGNX,0	 ; check sign
	goto	P_SIGN
	movlw	A'-'		; - sign
	call	DRV_LCD
	goto	E_SIGN
P_SIGN
	movlw	A'+'		; + sign
	call	DRV_LCD
E_SIGN	
	movf	EONE,w
	xorlw	H'30'
	btfss	STATUS,Z	; if a 0 use space instead (leading zero blanking)
	goto	DO_DIG
	call	SPACE1
	goto	NXT_DIG
DO_DIG
	movf	EONE,w
	call 		DRV_LCD
NXT_DIG
	movf	EZERO,w
	call	DRV_LCD
	call	SPACE1
	movlw	A'p'			;ppm
	call	DRV_LCD
	movlw	A'p'			;
	call	DRV_LCD
	movlw	A'm'			;
	call	DRV_LCD
	movlw	A'>'		; 
	call	DRV_LCD
	call	SPACE4
	call	SPACE1
	return
;______________________________________________________________

SW_ENTRY
; wait for switch open at first entry
	btfsc	START,0	; if start flag clear check sw
	goto	SW_PPM
	bsf		START,0
SW_PPM1
	btfss	PORTB,1
	goto	SW_PPM1
	movlw	D'255'
	call		DELAYX
SW_PPM
; check switches
	btfss	PORTB,1
	goto	INC_CAL
	btfss	PORTB,2
	goto	DEC_CAL
	goto	PPM_ADJ1		

DEC_CAL	; decrease to 0
	movf	PPM,w
	btfsc	STATUS,Z	; when 0 stop
	goto	PPM_ADJ1
;decrease
	decf	PPM,f
STO_PPM
; store PPM value
	movlw	EEPROM3
	call		EEREAD
	movf	PPM,w
	call		EEWRITE
	call		CAL_WRITE_DSP

; wait for switches open
WAIT_O
	btfss	PORTB,1
	goto	CONT_WAIT
	btfsc	PORTB,2
	goto	PPM_ADJ1
CONT_WAIT
	call		DELAY_TM
	goto	WAIT_O
INC_CAL
	incf		PPM,w
	sublw	D'100'
	btfss	STATUS,C		
	goto	STAY_100
	incf		PPM,f
	goto	STO_PPM
STAY_100
	movlw	D'100'
	movwf	PPM
	goto	STO_PPM

;
;**********************************************************************************************
        
;       24/24 PIC16 FIXED POINT DIVIDE ROUTINES
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: quotient AARG/BARG followed by remainder in REM
;       24/24 Bit Unsigned Fixed Point Divide 24/24 -> 24.24

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               24 bit unsigned fixed point divisor in BARGB0, BARGB1, BARGB2

;       Use:    CALL    FXD2424U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;		24 bit unsigned fixed point divisor in BARGB0, BARGB1,BARGB2
;               24 bit unsigned fixed point remainder in REMB0, REMB1, REMB2

;       Result: AARG, REM  <--  AARG / BARG



FXD2424U  
	  	CLRF            REMB0
                CLRF            REMB1
                CLRF            REMB2

                CLRF            TEMP

                RLF             AARGB0,W
                RLF             REMB2, F
                MOVF            BARGB2,W
                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F

                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                RLF             AARGB0, F

                MOVLW           7
                MOVWF           LPCOUNT

LOOPU2424A
	       RLF             AARGB0,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB0,0
                GOTO            UADD44LA

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44LA

UADD44LA   
	        ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44LA
		RLF             AARGB0, F

                DECFSZ          LPCOUNT, F
                GOTO            LOOPU2424A

                RLF             AARGB1,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB0,0
                GOTO            UADD44L8

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44L8

UADD44L8
	        ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44L8 
	        RLF             AARGB1, F

                MOVLW           7
                MOVWF           LPCOUNT

LOOPU2424B  
	        RLF             AARGB1,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB1,0
                GOTO            UADD44LB

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44LB

UADD44LB  
	        ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44LB 
	        RLF             AARGB1, F

                DECFSZ          LPCOUNT, F
                GOTO            LOOPU2424B

                RLF             AARGB2,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB1,0
                GOTO            UADD44L16

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44L16

UADD44L16
		ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44L16 
	       RLF             AARGB2, F

                MOVLW           7
                MOVWF           LPCOUNT

LOOPU2424C 
		RLF             AARGB2,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB2,0
                GOTO            UADD44LC

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44LC

UADD44LC
	        ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44LC 
		RLF             AARGB2, F

                DECFSZ          LPCOUNT, F
                GOTO            LOOPU2424C

                BTFSC           AARGB2,0
                GOTO            UOK44L
                MOVF            BARGB2,W
	       	ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F


UOK44L 
              return


;---------------------------------------------------------------------------------------------------------------------------------------------
; clock
	org H'800'

CLOCK

; timer 1 
	movlw	B'00000001'	; timer 1 fosc/4 1:1 prescaler so overflow 25 times per second if TMR1H is preloaded
; to count down from D40000
	movwf	T1CON

; convert ppm value (0-100 with 50 as the zero and 0 as -50 and 100 as +50) to
; zero ppm 0,  1 is +1, FF is -1, 02 is +2, FE is -2 etc
	movlw	D'50'
	subwf	PPM,w		 ; take 50 fromt PPM value
	btfss	STATUS,C	 ; if negative 
	goto	ALTER
	movwf	CORRECTION; interrupt rate correction in ppm
	goto	CLR_TIME
ALTER
; values are 0-50
	movf	PPM,w
	sublw	D'50'	; values 50-0
	movwf	CORRECTION
	comf	CORRECTION,f
CLR_TIME
; initial conditions
	clrf	TMR1H 		;
	bsf	TMR1H,7	; set MS bit
	clrf	TMR1L		; timer 1 is the seconds counter rolling every 4s
	clrf	SECONDS_RTC	; Initialize timer counter seconds for RTC
	clrf	SECONDS		; Initialize seconds timer counter used for count down timers
	clrf	MSECS		; milliseconds counter 25/second
	clrf	MINUTES	; minutes RTC
	clrf	HOURS		; hours RTC
	clrf	SEC1		; seconds counter lsb
	clrf	SEC2		; seconds counter 
	clrf	SEC3		; seconds counter msb

; interrupt settings
	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1,TMR1IE ; Enable Timer1 interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bcf 		PIR1,TMR1IF ; clear timer interrupt flag
	bsf		INTCON,PEIE	; enable peripheral interrupts
	bsf		INTCON,GIE	; enable interrupts

CLOCK_LINE
	bcf	PCLATH,3
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	movlw	A'^'		; 
	call	DRV_LCD
	movlw	A'h'		; 
	call	DRV_LCD
	movlw	A'^'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A's'		; 
	call	DRV_LCD
	call SPACE4
	call SPACE4
	call SPACE4

	bcf	PCLATH,3
	movlw	H'C0'		; address line 2 pos 1
	call	LOAD
	call	SPACE1
	movlw	A'C'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'C'		; 
	call	DRV_LCD	
	movlw	A'K'		; 
	call	DRV_LCD
	call SPACE2

; wait for switch to open
WAIT_CLOCK
	bcf		PCLATH,3
	call		DELAY_TM
	bsf		PCLATH,3
	btfss	PORTB,2	; minutes up switch (selects clock)
	goto	WAIT_CLOCK
HRS1
	bsf		PCLATH,3
	btfss	UPDATE_FLG,0	; when set update display
	goto	SW_CK_CK
	clrf		UPDATE_FLG
	bcf		PCLATH,3
	movlw	H'87'		; address line 1 pos 7
	call		LOAD
	movf	HOURS,w
	movwf	BIN1
	clrf		BIN2
	clrf		BIN3
	clrf		BIN4
	call		CAL_CONV	;  converts to BCD and ASCII 
	movf	EONE,w
	call 		DRV_LCD
	movf	EZERO,w
	call		DRV_LCD
;  show colon
	movlw	A':'
	bcf		PCLATH,3
	call		DRV_LCD	
	movf	MINUTES,w

	movwf	BIN1
	clrf		BIN2
	clrf		BIN3
	clrf		BIN4
	call		CAL_CONV	;  converts to BCD and ASCII 
	movf	EONE,w
	call 		DRV_LCD
	movf	EZERO,w
	call		DRV_LCD
;  show colon
	movlw	A':'
	bcf		PCLATH,3
	call		DRV_LCD	
	movf	SECONDS_RTC,w
	movwf	BIN1
	clrf		BIN2
	clrf		BIN3
	clrf		BIN4
	call		CAL_CONV	;  converts to BCD and ASCII 
	movf	EONE,w
	call 		DRV_LCD
	movf	EZERO,w
	call		DRV_LCD
	bcf		PCLATH,3
	call 		SPACE2

 ; seconds counter
	bcf		PCLATH,3
	movlw	H'C7'		; address line 2 pos 7
	call		LOAD
	movf	SEC1,w
	movwf	BIN1
	movf	SEC2,w
	movwf	BIN2
	movf	SEC3,w
	movwf	BIN3
	clrf		BIN4
	call		CAL_CONV	;  converts to BCD and ASCII 
	movlw	H'07'		; first 6 characters
	movwf	STOREX
	movlw	ESEVN		; MSD of freq
	movwf	FSR
SEC_4
	bsf		PCLATH,3
	movlw	H'30'		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	SEC_2
	bcf		PCLATH,3
	call		SPACE1		; leading 0's to space
	incf		FSR,f
	bsf		PCLATH,3
	decfsz	STOREX,f
	goto	SEC_4
	goto	SEC_3
SEC_2
	bcf		PCLATH,3
	movf	INDF,w
	call		DRV_LCD
	incf		FSR,f
	bsf		PCLATH,3
	decfsz	STOREX,f
	goto	SEC_2
SEC_3
	bcf		PCLATH,3
	movf	INDF,w
	call		DRV_LCD
	movlw	A's'
	call		DRV_LCD
	call		DELAY_TM; 200ms
	call		DELAY_TM; 200ms
SW_CK_CK

	bsf		PCLATH,3
	btfsc	PORTB,1	; hours up
	goto	LOOP_CK
; hours up
	bcf		INTCON,GIE	; disable interrupts
; check for 24 hours
	incf		HOURS,f
	movf	HOURS,w
	sublw	D'23'
	btfss	STATUS,C 	; 24 hours 
	clrf		HOURS
	bsf		UPDATE_FLG,0	;  update display
	bsf		INTCON,GIE	; enable interrupts
	bcf		PCLATH,3
	bsf		PCLATH,3
	goto	HRS1
LOOP_CK
	btfsc	PORTB,2	; minutes up
	goto	HRS1
	bcf		INTCON,GIE	; disable interrupts
; check for 60 minutes
	incf		MINUTES,f
	movf	MINUTES,w
	sublw	D'59'
	btfss	STATUS,C 	; 60 minutes
	clrf		MINUTES		; clear minutes
	clrf		SECONDS_RTC	; Initialize timer counter seconds for RTC
	clrf		SECONDS		; Initialize seconds timer counter used for count down timers
	clrf		MSECS		; milliseconds counter 25/second
	clrf		SEC1		; seconds counter
	clrf		SEC2
	clrf		SEC3
	bsf		UPDATE_FLG,0	;  update display
	bsf		INTCON,GIE	; enable interrupts
	bcf		PCLATH,3
	bsf		PCLATH,3
	goto	HRS1

INTERRUPT
	bcf		STATUS,RP0	; select memory bank 0
	bcf		STATUS,RP1	; select memory bank 0

; update clock 
	btfss	PIR1,TMR1IF
	goto	END_INTERRUPT
	bcf 		PIR1,TMR1IF ; clear timer interrupt flag

; PPM correction for timing tolerance correction for the crystal
; timer1 counts 1 million every second so a 1 change is 1ppm
; TMR1 counts the 1MHz clock 40000 times before interrupt than repeated 25 times to give 1 second
; adjust in parts per million (ppm). A TMR1L change by 1 in 40000 once every 25 gives 1ppm change.
; so use CORRECTION ppm value to add or subtract from H'C1', the 0ppm setting for a 4MHz crystal
; CORRECTION. Bit 7 set = -ppm, clear= +ppm. The + value will speed up the clock
; +1 to +50= 0 to D'50'
; -1 to -50 = H'FF' to H'CE'

; D40000 (H9C40) counts so preload FFFF-9C40=H63BF 
; compensate for stopping clock by several cycles = H'C6' for TMR1L
; change on a count of 10 for MSECS. That is once in a count of 25
; 25 interrupts per second

	movf	MSECS,w
	xorlw	D'10'			; when D'10' use ppm correction
	movlw	H'C6'			; use H'C6' for 0ppm change for TMR1L normally that's 24 times in 25
	btfss	STATUS,Z
	goto	ADD_TMR1L
; count of 10. The once in 25 change
	btfsc	CORRECTION,7	; check for - or plus
	goto	SEVEN_SET
 	movf	CORRECTION,w
	addlw	H'C6'			; value  from a 4MHz crystal
	btfsc	STATUS,C		; if over change MSB
	incf		TMR1H,f
	goto	ADD_TMR1L
SEVEN_SET ; values with bit 7 set for -
	comf	CORRECTION,w
	sublw	H'C6'
ADD_TMR1L
	bcf		T1CON,0 	; timer1 off	
	addwf	TMR1L,f
	btfsc	STATUS,C	; if over change MSB
	incf		TMR1H,f
	movlw	H'63'
	addwf	TMR1H,f
	bsf		T1CON,0 	; timer1 on	
	incf		MSECS,f
; check for 25 
	movf	MSECS,w
	sublw	D'25'		; 25 for 1s 
	btfsc	STATUS,Z 	; 
	clrf		MSECS		; clear milliseconds

TIMERS_RUN
	movf	MSECS,w
	btfss	STATUS,Z
	goto	END_INTERRUPT

	bsf		UPDATE_FLG,0	; set to indicate seconds update
; seconds
	incf		SECONDS,f	; seconds

; check for 60s 
	movf	SECONDS,w
	sublw	D'60'		; 60s 
	btfss	STATUS,Z 	; 
	goto	SEC_RTC		; not 60s
	clrf		SECONDS		; clear seconds

; seconds RTC
SEC_RTC
	incf		SECONDS_RTC,f	; seconds

; seconds counter (0-16,777,216)
	incfsz	SEC1,f
	goto	CK_60S
	incfsz	SEC2,f
	goto	CK_60S
	incf		SEC3,f

CK_60S
; check for 60s 
	movf	SECONDS_RTC,w
	sublw	D'60'		; 60s 
	btfsc	STATUS,Z 	; 
	clrf		SECONDS_RTC	; clear seconds

; minutes

	movf	SECONDS_RTC,w	; check if RTC seconds are clear
	btfss	STATUS,Z
	goto	END_INTERRUPT
	incf		MINUTES,f 	; next minutes

; check for 60 minutes
	movf	MINUTES,w
	sublw	D'60'
	btfss	STATUS,Z 	; 60 minutes
	goto	END_INTERRUPT	; not 60mins
	clrf		MINUTES		; clear minutes
	incf		HOURS,f		; next hours

; check for 24 hours
	movf	HOURS,w
	sublw	D'24'
	btfsc	STATUS,Z 	; 24 hours 
	clrf		HOURS

END_INTERRUPT
	movf	PCLATH_STO,w
	movwf	PCLATH	
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   	W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt


	end
